/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.SensorConnection;

class AccelSensor
implements Runnable {
    protected SensorConnection sconn;
    public boolean hasSensor;
    public Thread thr;
    protected boolean stop_thread;
    ImageViewer parent;
    private int sensorcnt;
    public double sensorReading;
    public double sensorReading2;
    public static final int LEFT = 1;
    public static final int UP = 2;
    public static final int RIGHT = 3;
    public static final int UPSIDEDOWN = 4;
    public int orientation = 2;

    AccelSensor(ImageViewer parent) {
        this.parent = parent;
        String sprop = System.getProperty("microedition.sensor.version");
        String propAutoRotate = parent.getAppProperty("auto-rotate");
        if (sprop == null || propAutoRotate == null || !propAutoRotate.toLowerCase().equals("true")) {
            this.hasSensor = false;
            return;
        }
        try {
            this.sconn = (SensorConnection)Connector.open((String)"sensor:acceleration");
            this.hasSensor = true;
        }
        catch (Exception e) {
            this.hasSensor = false;
        }
    }

    public void stopthread() {
        this.stop_thread = true;
    }

    boolean hasSensor() {
        return this.hasSensor;
    }

    public void start() {
        if (!this.hasSensor()) {
            return;
        }
        this.stop_thread = false;
        this.thr = new Thread(this);
        this.thr.start();
    }

    public synchronized void run() {
        while (!this.stop_thread) {
            try {
                this.wait(1000L);
                this.sensorData();
                this.orient();
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }
    }

    private void sensorData() throws IOException {
        Data[] data = this.sconn.getData(1);
        double[] values = data[0].getDoubleValues();
        this.sensorReading = values.length > 0 ? values[0] : 0.0;
        values = data[1].getDoubleValues();
        this.sensorReading2 = values.length > 0 ? values[0] : 0.0;
        System.out.println("sensorReading[0,1] = " + this.sensorReading + " " + this.sensorReading2);
    }

    private void orient() {
        int currOrient = this.orientation;
        if (this.sensorReading < -7.0) {
            currOrient = 3;
        } else if (-4.0 < this.sensorReading && this.sensorReading < 4.0) {
            currOrient = 2;
        } else if (this.sensorReading > 7.0) {
            currOrient = 1;
        }
        if (this.sensorReading2 < 0.0) {
            if (this.sensorReading < -4.0) {
                currOrient = 3;
            } else if (4.0 < this.sensorReading) {
                currOrient = 1;
            }
        }
        if (currOrient != this.orientation) {
            this.orientChanged(currOrient);
        }
    }

    private void orientChanged(int newOrient) {
        switch (this.orientation) {
            case 2: {
                if (newOrient == 1) {
                    this.parent.commandAction(this.parent.rotate, null);
                    break;
                }
                if (newOrient != 3) break;
                this.parent.commandAction(this.parent.rotateccw, null);
                break;
            }
            case 1: {
                if (newOrient == 2) {
                    this.parent.commandAction(this.parent.rotateccw, null);
                    break;
                }
                if (newOrient != 3) break;
                this.parent.commandAction(this.parent.rotate, null);
                this.parent.commandAction(this.parent.rotate, null);
                break;
            }
            case 3: {
                if (newOrient == 2) {
                    this.parent.commandAction(this.parent.rotate, null);
                    break;
                }
                if (newOrient != 1) break;
                this.parent.commandAction(this.parent.rotate, null);
                this.parent.commandAction(this.parent.rotate, null);
            }
        }
        this.orientation = newOrient;
    }
}

