/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Stack;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class ImageViewer
extends MIDlet
implements CommandListener {
    static final String HORZ_SEP = "------------------------";
    private static final String MEGA_ROOT = "/";
    private static final char SEP = '/';
    private static final String SEP_STR = "/";
    private static final String UP_DIRECTORY = "[UP DIR]";
    private Command view = new Command("View", 8, 1);
    Command rotateccw = new Command("RotateCCW", 1, 1);
    Command rotate = new Command("Rotate", 1, 1);
    Command exit = new Command("Exit", 7, 3);
    Command back = new Command("Back", 2, 2);
    Command zoomin = new Command("zoom +", 1, 1);
    Command zoomout = new Command("zoom -", 1, 1);
    Command imginfo = new Command("info", 1, 2);
    MRU mru = new MRU();
    List browser;
    private String currDirName = "/";
    private ScrollCanvas image;
    private Form imgInfoForm;
    boolean rotatef;
    AccelSensor accelSensor;
    private int showFileRetry = 0;
    private Alert alert;

    public void startApp() {
        this.loadRMS();
        boolean isAPIAvailable = false;
        if (System.getProperty("microedition.io.file.FileConnection.version") != null) {
            isAPIAvailable = true;
            try {
                this.showCurrDir();
            }
            catch (SecurityException e) {
                System.out.println(e);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        } else {
            StringBuffer splashText = new StringBuffer(this.getAppProperty("MIDlet-Name")).append("\n").append(this.getAppProperty("MIDlet-Vendor")).append(isAPIAvailable ? "" : "\nFileConnection API not available");
            Alert splashScreen = new Alert(null, splashText.toString(), null, AlertType.INFO);
            splashScreen.setTimeout(3000);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)splashScreen);
        }
        this.accelSensor = new AccelSensor(this);
        this.accelSensor.start();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean cond) {
        this.storeRMS();
        this.notifyDestroyed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRMS() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"mru", (boolean)true);
            RecordEnumeration e = recordStore.enumerateRecords(null, null, false);
            if (!e.hasNextElement()) {
                return;
            }
            int recId = e.nextRecordId();
            byte[] bMRU = recordStore.getRecord(recId);
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bMRU));
            this.mru.path = dis.readUTF();
            while (dis.available() != 0) {
                this.mru.files.push(dis.readUTF());
            }
            e.reset();
            while (e.hasNextElement()) {
                recordStore.deleteRecord(e.nextRecordId());
            }
        }
        catch (RecordStoreException rse) {
            System.out.println((Object)rse);
            rse.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception e) {}
        }
    }

    public void storeRMS() {
        Stack files = new Stack();
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"mru", (boolean)true);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            if (this.mru.path != null) {
                dos.writeUTF(this.mru.path);
            } else {
                dos.writeUTF("");
            }
            try {
                for (int i = 3; i > 0 && !this.mru.files.empty(); --i) {
                    files.push(this.mru.files.pop());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            while (!files.empty()) {
                dos.writeUTF((String)files.pop());
            }
            dos.flush();
            recordStore.addRecord(bos.toByteArray(), 0, bos.size());
        }
        catch (RecordStoreException rse) {
            System.out.println((Object)rse);
            rse.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
    }

    public void commandAction(Command c, Displayable d) {
        System.out.println("command:" + c + " displayable:" + d);
        if (c == this.view) {
            List curr = (List)d;
            final String currFile = curr.getString(curr.getSelectedIndex());
            System.out.println("currFile:" + currFile);
            new Thread(new Runnable(){

                public void run() {
                    if (currFile.endsWith("/") || currFile.equals(ImageViewer.UP_DIRECTORY)) {
                        System.out.println("traverseDir: " + currFile);
                        ImageViewer.this.traverseDirectory(currFile);
                    } else {
                        System.out.println("showFile: " + ImageViewer.this.currDirName + currFile);
                        ImageViewer.this.showFile(ImageViewer.this.currDirName + currFile);
                    }
                }
            }).start();
        } else if (c == this.back) {
            if (d == this.image) {
                Display.getDisplay((MIDlet)this).setCurrent(null);
                this.image.im = null;
                this.image.imoriginal = null;
                this.image = null;
                System.gc();
                new Thread(new Runnable(){

                    public void run() {
                        System.out.println("scd thread");
                        ImageViewer.this.showCurrDir();
                    }
                }).start();
            } else if (d == this.imgInfoForm) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.image);
            }
        } else if (c == this.rotate) {
            this.image.rotateImage(1);
        } else if (c == this.rotateccw) {
            this.image.rotateImage(2);
        } else if (c == this.zoomin) {
            this.image.zoomin();
        } else if (c == this.zoomout) {
            this.image.zoomout();
        } else if (c == this.imginfo) {
            this.imgInfoForm = new Form("Image Info");
            this.imgInfoForm.append("Width: " + this.image.im.getWidth());
            this.imgInfoForm.append("Height: " + this.image.im.getHeight());
            this.imgInfoForm.append("Name: " + this.image.fconn.getName());
            this.imgInfoForm.append("Path: " + this.image.fconn.getPath());
            try {
                this.imgInfoForm.append("Size: " + this.image.fconn.fileSize());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.imgInfoForm.append("Free Mem: " + Runtime.getRuntime().freeMemory() + "/" + Runtime.getRuntime().totalMemory());
            this.imgInfoForm.addCommand(this.back);
            this.imgInfoForm.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.imgInfoForm);
        } else if (c == this.exit) {
            this.destroyApp(false);
        }
    }

    void showCurrDir() {
        FileConnection currDir = null;
        try {
            Enumeration e;
            System.out.println("In showCurrDir");
            System.out.println("mega_root:/ cur_dir:" + this.currDirName);
            if ("/".equals(this.currDirName)) {
                this.browser = new List(this.currDirName, 3);
                this.mru.addToList(this.browser);
                e = FileSystemRegistry.listRoots();
            } else {
                System.out.println("connector: " + this.currDirName);
                currDir = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName), (int)1);
                e = currDir.list();
                this.browser = new List(this.currDirName, 3);
                this.browser.append(UP_DIRECTORY, null);
            }
            while (e.hasMoreElements()) {
                String fileName = (String)e.nextElement();
                System.out.println("fileName:" + fileName + " char_at:" + fileName.charAt(fileName.length() - 1));
                this.browser.append(fileName, null);
            }
            this.browser.setSelectCommand(this.view);
            this.browser.addCommand(this.exit);
            this.browser.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.browser);
            if (currDir != null) {
                currDir.close();
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    void traverseDirectory(String fileName) {
        System.out.println("fileName:" + fileName + " cur_dir:" + this.currDirName + " mega_root:" + "/");
        if (fileName.equals(HORZ_SEP)) {
            return;
        }
        if (this.currDirName.equals("/")) {
            if (fileName.equals(UP_DIRECTORY)) {
                return;
            }
            this.currDirName = fileName;
        } else if (fileName.equals(UP_DIRECTORY)) {
            System.out.println("up");
            int i = this.currDirName.lastIndexOf(47, this.currDirName.length() - 2);
            this.currDirName = i != -1 ? this.currDirName.substring(0, i + 1) : "/";
        } else {
            this.currDirName = this.currDirName + fileName;
        }
        if (!this.currDirName.equals("/")) {
            this.mru.path = this.currDirName;
        }
        this.showCurrDir();
    }

    void showFile(String fileName) {
        final String ffileName = fileName;
        if (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        System.out.println("free:" + Runtime.getRuntime().freeMemory());
        System.out.println("image: " + (Object)((Object)this.image));
        try {
            this.image = new ScrollCanvas(this, "file:///" + fileName);
        }
        catch (OutOfMemoryError e) {
            System.gc();
            if (this.showFileRetry == 2) {
                this.alert("Out of memory! [sf]");
                this.showFileRetry = 0;
                return;
            }
            ++this.showFileRetry;
            Runnable runnable = new Runnable(){

                public void run() {
                    System.out.println("serial rerun showFile(" + ffileName + " #" + ImageViewer.this.showFileRetry);
                    ImageViewer.this.showFile(ffileName);
                }
            };
            Display.getDisplay((MIDlet)this).callSerially(runnable);
            return;
        }
        this.mru.files.removeElement(fileName);
        this.mru.files.push(fileName);
        this.browser.removeCommand(this.exit);
        this.image.addCommand(this.zoomin);
        this.image.addCommand(this.zoomout);
        this.image.addCommand(this.rotate);
        this.image.addCommand(this.imginfo);
        this.image.addCommand(this.back);
        this.image.setCommandListener(this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.image);
    }

    void alert(String msg) {
        if (this.alert == null) {
            this.alert = new Alert("Alert");
            this.alert.setTimeout(1000);
            this.alert.setType(AlertType.ERROR);
        }
        this.alert.setString(msg);
        System.out.println("alert " + msg);
        Display d = Display.getDisplay((MIDlet)this);
        d.vibrate(100);
        d.setCurrent((Displayable)this.alert);
    }
}

