/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class ScrollCanvas
extends Canvas {
    public static final int ROTATE_CCW = 2;
    public static final int ROTATE_CW = 1;
    public static final int ORIENT_UP = 0;
    public static final int ORIENT_RIGHT = 1;
    public static final int ORIENT_DOWN = 2;
    public static final int ORIENT_LEFT = 3;
    int xscroll;
    int yscroll;
    private boolean showZoomStatus = false;
    private boolean isFullScreen = true;
    private int dispWidth;
    private int dispHeight;
    FileConnection fconn;
    Image im;
    Image imoriginal;
    private final ImageViewer midlet;
    private int x;
    private int y;
    private int w;
    private int h;
    private int zoomlevel = 1;
    int orientation;

    public ScrollCanvas(ImageViewer mid, String filename) {
        this.setFullScreenMode(this.isFullScreen);
        this.dispWidth = this.getWidth();
        this.dispHeight = this.getHeight();
        this.xscroll = this.dispWidth / 3;
        this.yscroll = this.dispHeight / 3;
        this.midlet = mid;
        String filen = filename;
        try {
            System.out.println("Connector.open(" + filen);
            this.fconn = (FileConnection)Connector.open((String)filen, (int)1);
            InputStream in = this.fconn.openInputStream();
            this.imoriginal = Image.createImage((InputStream)in);
            in.close();
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        this.x = 0;
        this.y = 0;
        this.im = Image.createImage((Image)this.imoriginal);
        this.w = this.im.getWidth();
        this.h = this.im.getHeight();
        this.orientation = 0;
    }

    public void paint(Graphics g) {
        if (this.im == null) {
            return;
        }
        String zm = "";
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0, 0, 0);
        g.drawImage(this.im, this.x, this.y, 20);
        switch (this.zoomlevel) {
            case 1: {
                zm = "100%";
                break;
            }
            case 2: {
                zm = "50%";
                break;
            }
            case 3: {
                zm = "33%";
                break;
            }
            case 4: {
                zm = "25%";
                break;
            }
            case 5: {
                zm = "fit to width";
            }
        }
        if (this.showZoomStatus) {
            g.drawString("zoom: " + zm, 0, 0, 20);
            this.showZoomStatus = false;
        }
    }

    protected void keyPressed(int keyCode) {
        this.scrollImage(keyCode, 1.3);
    }

    protected void keyRepeated(int keyCode) {
        this.scrollImage(keyCode, 1.0);
    }

    void scrollImage(int keyCode, double scrollAccel) {
        int keyAction;
        try {
            keyAction = this.getGameAction(keyCode);
        }
        catch (IllegalArgumentException e) {
            System.out.println("keyCode:" + keyCode + " caused IllegalArgumentException in getGameAction(keyCode)");
            keyAction = 0;
        }
        if (keyAction == 0) {
            keyAction = keyCode;
        }
        switch (keyAction) {
            case 1: 
            case 50: {
                this.y = (int)((double)this.y + (double)this.yscroll * scrollAccel);
                break;
            }
            case 5: 
            case 54: {
                this.x = (int)((double)this.x - (double)this.xscroll * scrollAccel);
                break;
            }
            case 6: 
            case 56: {
                this.y = (int)((double)this.y - (double)this.yscroll * scrollAccel);
                break;
            }
            case 2: 
            case 52: {
                this.x = (int)((double)this.x + (double)this.xscroll * scrollAccel);
                break;
            }
            case 8: 
            case 53: {
                this.isFullScreen = !this.isFullScreen;
                this.setFullScreenMode(this.isFullScreen);
                break;
            }
            case 11: 
            case 42: {
                this.midlet.commandAction(this.midlet.zoomout, (Displayable)this);
                return;
            }
            case 12: 
            case 35: {
                this.midlet.commandAction(this.midlet.zoomin, (Displayable)this);
                return;
            }
            case 48: {
                this.midlet.commandAction(this.midlet.rotate, (Displayable)this);
                return;
            }
            default: {
                System.out.println("keyAction:" + keyAction);
            }
        }
        System.out.println("im height:" + this.im.getHeight() + " dispHeight:" + this.dispHeight);
        this.y = Math.max(this.y, -this.im.getHeight() + this.dispHeight);
        this.x = Math.max(this.x, -this.im.getWidth() + this.dispWidth);
        if (this.y > 0) {
            this.y = 0;
        }
        if (this.x > 0) {
            this.x = 0;
        }
        System.out.println("xy = " + this.x + ":" + this.y);
        this.repaint();
    }

    public void zoomin() {
        if (this.zoomlevel != 1) {
            --this.zoomlevel;
        }
        this.rescaleImage(this.zoomlevel);
    }

    public void zoomout() {
        if (this.zoomlevel != 5) {
            ++this.zoomlevel;
        }
        this.rescaleImage(this.zoomlevel);
    }

    public void rescaleImage(int zoom) {
        Image newImage;
        this.showZoomStatus = true;
        this.zoomlevel = zoom;
        this.im = this.imoriginal;
        this.w = this.im.getWidth();
        this.h = this.im.getHeight();
        this.x = 0;
        this.y = 0;
        this.orientation = 0;
        if (zoom == 1) {
            this.repaint();
            return;
        }
        if (zoom == 5) {
            zoom = this.w / this.getWidth();
        }
        this.im = null;
        System.gc();
        int d_zoom = zoom;
        int width = this.w / d_zoom;
        int height = this.h / d_zoom;
        try {
            newImage = Image.createImage((int)width, (int)height);
        }
        catch (OutOfMemoryError e) {
            this.midlet.alert("Out of Memory! [resi]");
            System.gc();
            this.im = this.imoriginal;
            return;
        }
        Graphics g = newImage.getGraphics();
        System.out.println("zoomlevel: " + zoom + " width: " + width + " height: " + height);
        int[] rgb = new int[this.w];
        int[] rgb_buf = new int[width];
        for (int y = 0; y < height; ++y) {
            this.imoriginal.getRGB(rgb, 0, this.w, 0, y * d_zoom, this.w, 1);
            for (int x = 0; x < width; ++x) {
                rgb_buf[x] = rgb[x * d_zoom];
            }
            g.drawRGB(rgb_buf, 0, width, 0, y, width, 1, false);
        }
        System.out.println("zoom finish");
        this.im = newImage;
        this.w = this.im.getWidth();
        this.h = this.im.getHeight();
        this.repaint();
    }

    private void rotateImageInPlace(int direction) {
        int nextOrientation;
        int currOrientation = this.orientation;
        System.out.println("riip: " + direction);
        if (direction == 1) {
            nextOrientation = (this.orientation + 1) % 4;
        } else if (direction == 2) {
            nextOrientation = (this.orientation - 1 + 4) % 4;
        } else {
            return;
        }
        this.im = null;
        System.gc();
        try {
            this.im = this.rotateImage(this.imoriginal, nextOrientation);
            this.rotateImageViewCenter(currOrientation, nextOrientation);
            this.w = this.im.getWidth();
            this.h = this.im.getHeight();
        }
        catch (OutOfMemoryError e) {
            System.gc();
            try {
                this.im = this.rotateImage(this.imoriginal, nextOrientation);
                this.rotateImageViewCenter(currOrientation, nextOrientation);
                this.w = this.im.getWidth();
                this.h = this.im.getHeight();
            }
            catch (OutOfMemoryError e2) {
                this.midlet.alert("Out of Memory! [riip]");
                Runnable runn = new Runnable(){

                    public void run() {
                        System.gc();
                        ScrollCanvas.this.im = ScrollCanvas.this.imoriginal;
                        ScrollCanvas.this.w = ScrollCanvas.this.im.getWidth();
                        ScrollCanvas.this.h = ScrollCanvas.this.im.getHeight();
                        ScrollCanvas.this.orientation = 0;
                        ScrollCanvas.this.repaint();
                    }
                };
                this.delayCallSerially(1000L, runn);
                return;
            }
        }
        this.repaint();
    }

    void delayCallSerially(final long msec, final Runnable runn) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread thread = Thread.currentThread();
                synchronized (thread) {
                    try {
                        Thread.currentThread().wait(msec);
                    }
                    catch (Exception ew) {
                        System.out.println("dcs:" + ew);
                    }
                }
                Display.getDisplay((MIDlet)ScrollCanvas.this.midlet).callSerially(runn);
            }
        }).start();
    }

    private void rotateImageViewCenter(int orientation, int nextOrientation) {
        int dispHeight_2 = this.dispHeight / 2;
        int dispWidth_2 = this.dispWidth / 2;
        int x_anchor = -this.x;
        int y_anchor = -this.y;
        int h = this.h;
        int w = this.w;
        int cx = x_anchor + dispWidth_2;
        int cy = y_anchor + dispHeight_2;
        while (orientation % 4 != nextOrientation) {
            int temp = w;
            w = h;
            h = temp;
            int cy0 = cy;
            cy = cx;
            cx = w - cy0;
            ++orientation;
        }
        x_anchor = cx - dispWidth_2;
        y_anchor = cy - dispHeight_2;
        this.x = -x_anchor;
        this.y = -y_anchor;
    }

    private Image rotateImage(Image imSrc, int orientation) throws OutOfMemoryError {
        Image newImage;
        System.out.println("ri2: " + orientation);
        Image im = this.imoriginal;
        int w_imorig = im.getWidth();
        int h_imorig = im.getHeight();
        this.orientation = orientation;
        if (orientation == 1) {
            newImage = Image.createImage((int)h_imorig, (int)w_imorig);
            Graphics g = newImage.getGraphics();
            int transform = 5;
            int ychunk = 0;
            while (ychunk * 100 < h_imorig) {
                int destx = Math.max(0, h_imorig - ychunk * 100 - 100);
                int regionh = Math.min(100, h_imorig - ychunk * 100);
                int xchunk = 0;
                while (xchunk * 100 < w_imorig) {
                    int desty = xchunk * 100;
                    int regionw = Math.min(100, w_imorig - xchunk * 100);
                    g.drawRegion(im, xchunk * 100, ychunk * 100, regionw, regionh, transform, destx, desty, 20);
                    ++xchunk;
                }
                ++ychunk;
            }
        } else if (orientation == 3) {
            newImage = Image.createImage((int)h_imorig, (int)w_imorig);
            Graphics g = newImage.getGraphics();
            int transform = 6;
            int ychunk = 0;
            while (ychunk * 100 < h_imorig) {
                int destx = ychunk * 100;
                int regionh = Math.min(100, h_imorig - ychunk * 100);
                int xchunk = 0;
                while (xchunk * 100 < w_imorig) {
                    int desty = Math.max(0, w_imorig - xchunk * 100 - 100);
                    int regionw = Math.min(100, w_imorig - xchunk * 100);
                    g.drawRegion(im, xchunk * 100, ychunk * 100, regionw, regionh, transform, destx, desty, 20);
                    ++xchunk;
                }
                ++ychunk;
            }
        } else if (orientation == 2) {
            newImage = Image.createImage((int)w_imorig, (int)h_imorig);
            Graphics g = newImage.getGraphics();
            int transform = 3;
            int ychunk = 0;
            while (ychunk * 100 < h_imorig) {
                int desty = Math.max(0, h_imorig - ychunk * 100 - 100);
                int regionh = Math.min(100, h_imorig - ychunk * 100);
                int xchunk = 0;
                while (xchunk * 100 < w_imorig) {
                    int destx = Math.max(0, w_imorig - xchunk * 100 - 100);
                    int regionw = Math.min(100, w_imorig - xchunk * 100);
                    g.drawRegion(im, xchunk * 100, ychunk * 100, regionw, regionh, transform, destx, desty, 20);
                    ++xchunk;
                }
                ++ychunk;
            }
        } else {
            return Image.createImage((Image)imSrc);
        }
        return newImage;
    }

    public void rotateImage(int direction) {
        Image newImage2;
        if (this.zoomlevel == 1) {
            this.rotateImageInPlace(direction);
            return;
        }
        try {
            newImage2 = Image.createImage((int)this.h, (int)this.w);
        }
        catch (OutOfMemoryError e) {
            Object newImage2 = null;
            this.midlet.alert("Out of Memory! [roti]");
            System.gc();
            return;
        }
        Graphics g = newImage2.getGraphics();
        if (direction == 1) {
            int transform = 5;
            int ychunk = 0;
            while (ychunk * 100 < this.h) {
                int destx = Math.max(0, this.h - ychunk * 100 - 100);
                int xchunk = 0;
                while (xchunk * 100 < this.w) {
                    int desty = xchunk * 100;
                    int regionh = Math.min(100, this.h - ychunk * 100);
                    int regionw = Math.min(100, this.w - xchunk * 100);
                    g.drawRegion(this.im, xchunk * 100, ychunk * 100, regionw, regionh, transform, destx, desty, 20);
                    ++xchunk;
                }
                ++ychunk;
            }
            int x0 = -this.x;
            int y0 = -this.y;
            this.x = this.h - y0 - (this.dispHeight + this.dispWidth) / 2;
            this.y = x0 + (this.dispWidth - this.dispHeight) / 2;
            this.x = -this.x;
            this.y = -this.y;
            this.orientation = (this.orientation + 1) % 4;
        } else if (direction == 2) {
            int transform = 6;
            int ychunk = 0;
            while (ychunk * 100 < this.h) {
                int destx = ychunk * 100;
                int xchunk = 0;
                while (xchunk * 100 < this.w) {
                    int desty = Math.max(0, this.w - xchunk * 100 - 100);
                    int regionh = Math.min(100, this.h - ychunk * 100);
                    int regionw = Math.min(100, this.w - xchunk * 100);
                    g.drawRegion(this.im, xchunk * 100, ychunk * 100, regionw, regionh, transform, destx, desty, 20);
                    ++xchunk;
                }
                ++ychunk;
            }
            int x0 = -this.x;
            int y0 = -this.y;
            this.y = this.w - x0 - (this.dispHeight + this.dispWidth) / 2;
            this.x = y0 + (this.dispHeight - this.dispWidth) / 2;
            this.x = -this.x;
            this.y = -this.y;
            this.orientation = (this.orientation - 1) % 4;
        } else {
            return;
        }
        this.im = newImage2;
        this.w = this.im.getWidth();
        this.h = this.im.getHeight();
        newImage2 = null;
        System.gc();
        this.repaint();
    }

    protected void sizeChanged(int w, int h) {
        super.sizeChanged(w, h);
        this.dispHeight = h;
        this.dispWidth = w;
        this.xscroll = this.dispWidth / 3;
        this.yscroll = this.dispHeight / 3;
    }
}

